<?php

namespace App\Controller;


use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Doctrine\ORM\EntityManagerInterface;
use App\Model\AdminDto;
use App\Entity\Admin;


use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Admin')]

final class AdminController extends AbstractController
{
     private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    
    #[Route('/admins', name: 'Admin', methods: ['GET'])]
    public function getAll(): JsonResponse
    {
       $admin = $this->entityManager->getRepository(Admin::class);


       return $this->json($admin->findAll());
    }

    #[Route('/admins/{id}', name: 'admin_show', methods: ['GET'])]

    public function show(string $id): JsonResponse
    {
        $admin = $this->entityManager->getRepository(Admin::class)->find($id);
        
        if (!$admin) {
            return new JsonResponse(['message' => 'No Admin with this id was found'   ], Response::HTTP_NOT_FOUND);

        
        }
        
        return $this->json($admin);
    }


    #[Route('/admins', name: 'admin_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] AdminDto $payload, ): JsonResponse
    {
        $admin = new Admin();

        $admin->setFirstName($payload->firstName);
        $admin->setLastName($payload->lastName);
        $admin->setEmail($payload->email);
        $admin->setStatus($payload->status);
        $admin->setCreatedAt(new \DateTimeImmutable );
        
        $this->entityManager->persist($admin);
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Admin created succ...' . $admin->getFirstName()]);
    }

    #[Route('/admins/{id}', name: 'admin_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] AdminDto $payload, ): JsonResponse
    {
        $admin = $this->entityManager->getRepository(Admin::class)->find($id);
        
        if (!$admin) {
            return new JsonResponse(['message' => 'No Admin with this id was found'], Response::HTTP_NOT_FOUND);
        }
    
        $admin->setFirstName($payload->firstName);
        $admin->setLastName($payload->lastName);
        $admin->setEmail($payload->email);
        $admin->setStatus($payload->status);
        $admin->setUpdatedAt(new \DateTimeImmutable );
        
    
        $this->entityManager->persist($admin);
        $this->entityManager->flush();


        return new JsonResponse(['message' => 'Admin updated succ...']);
    }


    #[Route('/admins/{id}', name: 'Admin_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $admin = $this->entityManager->getRepository(Admin::class);
        
        if (!$admin) {
            return new JsonResponse(['message' => 'No Admin with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($admin->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Admin deleted successfully']);
    }
}
