<?php

namespace App\Controller;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use App\Model\chartDto;
use App\Entity\Chart;
use App\Entity\Users;
use OpenApi\Attributes as OA;


use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Chart')]

final class ChartController extends AbstractController
{ private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }


    #[Route('/charts/{id}', name: 'app_chart',  methods: ['GET'])]
    public function get(EntityManagerInterface $entityManager, string $id): Response
    {
        $chart = $entityManager->getRepository(Chart::class);

        return $this->json($chart->find($id));

    }
    #[Route('/charts', name: 'app_chart_all',  methods: ['GET'])]
    public function getAll(EntityManagerInterface $entityManager): Response
    {
        $chart = $entityManager->getRepository(Chart::class);

        return $this->json($chart->findAll());
    }

     #[Route('/charts', name: 'app_charts_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] chartDto $payload, ): JsonResponse
    {
      $chart = new Chart();
      $usersRepo = $this->entityManager->getRepository(Users::class);

      $user= $usersRepo->find($payload->userId);
      $chart->setCreatedAt(new \DateTimeImmutable);
      $chart->setUserId($user);
      
      $this->entityManager->persist($chart);
      $this->entityManager->flush();

      return new JsonResponse('Created succ...' .$chart->getId());
    }
      #[Route('/charts/{id}', name: 'app_charts_add', methods: ['PUT'])]
    public function update( #[MapRequestPayload] chartDto $payload, string $id, ): JsonResponse
    { 
        $chart = $this->entityManager->getRepository(Chart::class)->find($id);
        
        if (!$chart) {
            return new JsonResponse([ 'No chart with this id was found'], Response::HTTP_NOT_FOUND);
      
          }
          
      $userRepo = $this->entityManager->getRepository(Users::class);

      $user = $userRepo->find($payload->userId);
      $chart->setUpdatedtedAt(new \DateTimeImmutable);
      $chart->setUserId($user);
      
      $this->entityManager->persist($chart);
      $this->entityManager->flush();

      return new JsonResponse('Updated succ...' .$chart->getId());
    }
      #[Route('/charts/{id}', name: 'charts_delete', methods: ['DELETE'])]
     public function delete(string $id): JsonResponse
    {
        $chart = $this->entityManager->getRepository(Chart::class);
        
        if (!$chart) {
            return new JsonResponse([ 'No chart with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($chart->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['chart deleted successfully']);
    }
}
