<?php

namespace App\Controller;

use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use App\Model\serviceCategoryDto;
use App\Entity\ServiceCategory;
use App\Entity\Admin;
use App\Entity\ServiceDomain;
use OpenApi\Attributes as OA;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Service Category')]

final class ServiceCategoryController extends AbstractController
{  
    
  private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }


    #[Route('/service-categories/{id}', name: 'app_ServiceCategory',  methods: ['GET'])]
    public function get(EntityManagerInterface $entityManager, string $id): Response
    {
        $serviceCategory = $entityManager->getRepository(ServiceCategory::class);

        return $this->json($serviceCategory->find($id));

    }
    #[Route('/service-categories', name: 'app_ServiceCategory_all',  methods: ['GET'])]
    public function getAll(EntityManagerInterface $entityManager): Response
    {
        $serviceCategory = $entityManager->getRepository(ServiceCategory::class);

        return $this->json($serviceCategory->findAll());
    }

     #[Route('/service-categories', name: 'app_ServiceCategory_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] serviceCategoryDto $payload, ): JsonResponse
    {
      $serviceCategory = new ServiceCategory();
      $adminRepo = $this->entityManager->getRepository(Admin::class);
      $serviceDomainRepo = $this->entityManager->getRepository(ServiceDomain::class);
      
      
      $admin = $adminRepo->find($payload->adminId);
      $serviceDomain = $serviceDomainRepo->find($payload->servicedomainId);
      $serviceCategory-> setAdminId($admin);
      $serviceCategory-> setServicedomainId($serviceDomain);
      $serviceCategory->setName($payload->name);
      $serviceCategory->setDescription($payload->description);  
      $serviceCategory->setCreatedAt(new \DateTimeImmutable);
      
      $this->entityManager->persist($serviceCategory);
      $this->entityManager->flush();

      return new JsonResponse('Created succ...' .$serviceCategory->getId());
    }
      #[Route('/service-categories/{id}', name: 'app_Category_add', methods: ['PUT'])]
    public function update( #[MapRequestPayload] serviceCategoryDto $payload, string $id, ): JsonResponse
    { 
        $serviceCategory = $this->entityManager->getRepository(ServiceCategory::class)->find($id);
        
        if (!$serviceCategory) {
            return new JsonResponse([ 'No serviceDomain with this id was found'], Response::HTTP_NOT_FOUND);
      
          }
          
      $adminRepo = $this->entityManager->getRepository(Admin::class);
      $serviceDomainRepo = $this->entityManager->getRepository(ServiceDomain::class);
      
      
      $admin = $adminRepo->find($payload->adminId);
      $serviceDomain = $serviceDomainRepo->find($payload->servicedomainId);
      $serviceCategory-> setAdminId($admin);
      $serviceCategory-> setServicedomainId($serviceDomain);
      $serviceCategory->setName($payload->name);
      $serviceCategory->setDescription($payload->description);  
      $serviceCategory->setUpdatedAt(new \DateTimeImmutable);
      
      $this->entityManager->persist($serviceCategory);
      $this->entityManager->flush();

      return new JsonResponse('Updated succ...' .$serviceCategory->getId());
    }
      #[Route('/service-categories/{id}', name: 'ServiceCategory_delete', methods: ['DELETE'])]
     public function delete(string $id): JsonResponse
    {
        $serviceCategory = $this->entityManager->getRepository(ServiceCategory::class);
        
        if (!$serviceCategory) {
            return new JsonResponse([ 'No serviceCategory with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($serviceCategory->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['serviceCategory deleted successfully']);
    }
}
