<?php

namespace App\Controller;
use App\Entity\ServicePortfolio;
use App\Entity\Service;
use ServicePortfolio\Model\ServicePortfolioDto;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Service Portfolio')]

final class ServicePortfolioController extends AbstractController
{    
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager) {
        $this->entityManager = $entityManager;
    }
    #[Route('/service-portfolios', name: 'app_serviceportfolio', methods:['GET'])]
    public function getAll(): JsonResponse
    {
        $servicePortfolio = $this->entityManager->getRepository(ServicePortfolio::class);
        return $this->Json($servicePortfolio->findAll());
    }

    #[Route('/service-portfolios/{id}', name: 'serviceportfolio_show', methods:['GET'])]
    Public function show(string $id): JsonResponse
    {
        $servicePortfolio = $this->entityManager->getRepository(ServicePortfolio::class)->find($id);

        if(!$servicePortfolio){
             return new JsonResponse(['message'=>'No ServicePortfolio with this id found'], Response::HTTP_NOT_FOUND);
        }
        return $this->json($servicePortfolio);
    }

    #[Route('/service-portfolios', name: 'serviceportfolio_create', methods: ['POST'])]
    public function create(#[MapRequestPayload] ServicePortfolioDto $payload, ): JsonResponse
    {
      $servicePortfolio= new ServicePortfolio();
      $serviceRepo = $this->entityManager->getRepository(Service::class);
      $service = $serviceRepo->find($payload->serviceId);
     
      $servicePortfolio->setServiceId($service);
      $servicePortfolio->setPhotoUrl($payload->photoUrl);
      $servicePortfolio->setDescription($payload->description);
      $servicePortfolio->setTitle($payload->title);
      $servicePortfolio->setCreatedAt(new \DateTimeImmutable());
    

      $this->entityManager->persist($servicePortfolio);
      $this->entityManager->flush();

       return new JsonResponse(['message' => 'ServicePortfolio created successfully' .$servicePortfolio->getId()]);

    }

     #[Route('/service-portfolios/{id}', name: 'serviceportfolio_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] ServicePortfolioDto $payload, ): JsonResponse
    {
        $servicePortfolio = $this->entityManager->getRepository(ServicePortfolio::class)->find($id);

        if (!$servicePortfolio) {
            return new JsonResponse(['message' => 'No ServicePortfolio with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $serviceRepo = $this->entityManager->getRepository(Service::class);
        $service = $serviceRepo->find($payload->serviceId);

        $servicePortfolio->setServiceId($service);
        $servicePortfolio->setPhotoUrl($payload->photoUrl);
        $servicePortfolio->setDescription($payload->description);
        $servicePortfolio->setTitle($payload->title);
        $servicePortfolio->setUpdatedAt(new \DateTimeImmutable());
                

        $this->entityManager->flush();

        return new JsonResponse(['message' => 'ServicePortfolio updated successfully' .$servicePortfolio->getId()]);
    }

    #[Route('/service-portfolios/{id}', name: 'serviceportfolio_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $servicePortfolio = $this->entityManager->getRepository(ServicePortfolio::class);
        
        if (!$servicePortfolio) {
            return new JsonResponse(['message' => 'No ServicePortfolio with this id was found'], Response::HTTP_NOT_FOUND);
        }
        
        $this->entityManager->remove($servicePortfolio->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'Service Portfolio deleted successfully']);
    }

}
