<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Doctrine\ORM\EntityManagerInterface;
use App\Model\UserDevicesDto;
use App\Entity\UserDevices;
use App\Entity\Users;



use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'User Devices')]

final class UserDevicesController extends AbstractController
{
     private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    
    #[Route('/user-devices', name: 'UsersDevices', methods: ['GET'])]
    public function getAll(): JsonResponse
    {
       $userDevices = $this->entityManager->getRepository(UserDevices::class);

       return $this->json($userDevices->findAll());
    }

    #[Route('/user-devices/{id}', name: 'userdevices_show', methods: ['GET'])]

    public function show(string $id): JsonResponse
    {
        $userDevices = $this->entityManager->getRepository(UserDevices::class)->find($id);
        
        if (!$userDevices) {
            return new JsonResponse(['message' => 'No User Devices with this id was found'   ], Response::HTTP_NOT_FOUND);

        
        }
        
        return $this->json($userDevices);
    }

     #[Route('/user-devices', name: 'userdevice_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] UserDevicesDto $payload, ): JsonResponse
    {
        $userDevices = new UserDevices();

        $usersRepo = $this->entityManager->getRepository(Users::class);

        $users = $usersRepo->find($payload->userId);
        $userDevices->setUserAgent($payload->userAgent);
        $userDevices->setIp($payload->ip);
        $userDevices->setUserId($users);
        $userDevices->setCreatedAt(new \DateTimeImmutable );
        
    
        $this->entityManager->persist($userDevices);
        $this->entityManager->flush();
        return new JsonResponse(['message' => 'UserDevice created succ...' . $userDevices->getId()]);
    }

    #[Route('/user-devices/{id}', name: 'userdevice_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] UserDevicesDto $payload, ): JsonResponse
    {
         $userDevices = $this->entityManager->getRepository(UserDevices::class)->find($id);
        
        if (!$userDevices) {
            return new JsonResponse(['message' => 'No User Device with this id was not found'], Response::HTTP_NOT_FOUND);
        }

        $usersRepo = $this->entityManager->getRepository(Users::class);
        $users = $usersRepo->find($payload->userId);
        $userDevices->setUserAgent($payload->userAgent);
        $userDevices->setIp($payload->ip);
        $userDevices->setUserID($users);
        $userDevices->setUpdatedAt(new \DateTimeImmutable );
        
    
        $this->entityManager->persist($userDevices);
        $this->entityManager->flush();
        return new JsonResponse(['message' => 'User Device updated succ... with id' . $userDevices->getId()]);
    }


    #[Route('/user-devices/{id}', name: 'userdevices_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $userDevices = $this->entityManager->getRepository(UserDevices::class);
        
        if (!$userDevices) {
            return new JsonResponse(['message' => 'No User Device with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($userDevices->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'User device deleted successfully']);
    }

}
