<?php

namespace App\Controller;


use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Doctrine\ORM\EntityManagerInterface;
use App\Model\UsersDto;
use App\Entity\Users;


use OpenApi\Attributes as OA;

#[Route('/api', name: 'api_', format: 'json')]
#[OA\Tag(name: 'Users')]

final class UsersController extends AbstractController
{
     private $entityManager;
    
    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    
    #[Route('/users', name: 'Users', methods: ['GET'])]
    public function getAll(): JsonResponse
    {
       $users = $this->entityManager->getRepository(Users::class);


       return $this->json($users->findAll());
    }

    #[Route('/users/{id}', name: 'users_show', methods: ['GET'])]

    public function show(string $id): JsonResponse
    {
        $users = $this->entityManager->getRepository(Users::class)->find($id);
        
        if (!$users) {
            return new JsonResponse(['message' => 'No User with this id was found'   ], Response::HTTP_NOT_FOUND);

        
        }
        
        return $this->json($users);
    }

    #[Route('/users', name: 'users_create', methods: ['POST'])]
    public function create( #[MapRequestPayload] UsersDto $payload, ): JsonResponse
    {
        $users = new Users();
        $users->setFirstName($payload->firstName);
        $users->setLastName($payload->lastName);
        $users->setEmail($payload->email);
        $users->setPassword($payload->password);
        $users->setCountry($payload->country);
        $users->setAccountType($payload->accountType);
        $users->setAddress($payload->address);
        $users->setPhoneNumber($payload->phoneNumber);
        $users->setWhatsappNumber($payload->whatsappNumber);
        $users->setToken($payload->token);
        $users->setBlockedStatus($payload->blockedStatus);
        $users->setCreatedAt(new \DateTimeImmutable );
        $users->setNotifyAt(new \DateTimeImmutable );
    
        $this->entityManager->persist($users);
        $this->entityManager->flush();



        return new JsonResponse(['message' => ' created succ... User ' . $users->getFirstName()]);
    }
    
    #[Route('/users/{id}', name: 'users_update', methods: ['PUT'])]
    public function update(string $id, #[MapRequestPayload] UsersDto $payload, ): JsonResponse
    {
         $users = $this->entityManager->getRepository(Users::class)->find($id);
        
        if (!$users) {
            return new JsonResponse(['message' => 'No user with this id was not found'], Response::HTTP_NOT_FOUND);
        }

        $users->setFirstName($payload->firstName);
        $users->setLastName($payload->lastName);
        $users->setEmail($payload->email);
        $users->setPassword($payload->password);
        $users->setCountry($payload->country);
        $users->setAddress($payload->address);
        $users->setAccountType($payload->accountType);
        $users->setAddress($payload->address);
        $users->setPhoneNumber($payload->phoneNumber);
        $users->setWhatsappNumber($payload->whatsappNumber);
        $users->setToken($payload->token);
        $users->setBlockedStatus($payload->blockedStatus);
        $users->setUpdatedtedAt(new \DateTimeImmutable );
        $users->setNotifyAt(new \DateTimeImmutable );
        
        $this->entityManager->persist($users);
        $this->entityManager->flush();



        return new JsonResponse(['message' => ' updated succ... User ' . $users->getFirstName()]);
    }



     #[Route('/users/{id}', name: 'users_delete', methods: ['DELETE'])]
    public function delete(string $id): JsonResponse
    {
        $users = $this->entityManager->getRepository(Users::class);
        
        if (!$users) {
            return new JsonResponse(['message' => 'No User with this id was found'], Response::HTTP_NOT_FOUND);
        }

        $this->entityManager->remove($users->find($id));
        $this->entityManager->flush();

        return new JsonResponse(['message' => 'User deleted successfully']);
    }

}
