<?php

namespace App\Model;

use Symfony\Component\Validator\Constraints as Assert;

class UsersDto
{
    public function __construct(
        #[Assert\NotBlank]
        public string $firstName,

        #[Assert\NotBlank]
        public string $lastName,
        
        #[Assert\Email(message:'The email "{{ value }}" is not valid')]
        public string $email,

        #[Assert\Length(min: 8, minMessage: 'Password must be at least {{ limit }} characters long')]
        public string $password,

        #[Assert\NotBlank]
        public string $country,

         #[Assert\NotBlank]
        public string $address,

        #[Assert\NotBlank]
        public string $accountType,

        #[Assert\NotBlank]
        public int $phoneNumber,

        #[Assert\NotBlank]
        public int $whatsappNumber,

         #[Assert\NotBlank]
        public string $token,

        #[Assert\NotBlank]
        public string $blockedStatus,
    

        

        

    ) {
    }
}
?>